package org.msh.etbm.services.mobile;

import org.msh.etbm.rest.mobile.SyncFromServerRequest;
import org.msh.tb.entities.Tbunit;

/**
 * Interface that a class must implement in order to expose the interface
 * to generate initialization data to send to the mobile
 * Created by rmemoria on 15/4/17.
 */
public interface InitAndSyncDataGenerator<E> {
    /**
     * Generates data response when initializing a unit
     * @param unit
     * @return
     */
    E generate(Tbunit unit);

    /**
     * Generates data response when synchronizing a unit
     * @param unit
     * @param serverIndex
     * @return
     */
    E generate(Tbunit unit, SyncFromServerRequest serverIndex);
}
